<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Berita extends REST_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Admin_master');
        
    }

   public function inputberita_post(){

        $this->load->library('form_validation');

        $data = array(
            "iduser" => $this->input->post('iduser'),
            "judulberita" => $this->input->post('judulberita'),
            "deskripsiberita" => $this->input->post('deskripsiberita'),
            "tanggalberita" => date('Y-m-d h:i:s',strtotime('now')),
            "fotoberita" => $this->input->post('fotoberita'),
            "linkvideoberita" => $this->input->post('linkvideoberita'),
        );

        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');
        $this->form_validation->set_rules('fotoberita', 'fotoberita', 'trim|required');
        $this->form_validation->set_rules('judulberita', 'judulberita', 'trim|required');
        $this->form_validation->set_rules('deskripsiberita', 'deskripsiberita', 'trim|required');
        $this->form_validation->set_rules('linkvideoberita', 'linkvideoberita', 'trim|required');

        if ($this->form_validation->run() != false) {
            
            //Upload Foto
            $image = base64_decode($this->input->post("fotoberita"));
        
            $image_name = md5(uniqid(rand(), true));

            $filename = $image_name . '.' . 'png';
            //rename file name with random number
            $path = "../../imageapps/".$filename;
            //image uploading folder path

            file_put_contents($path, $image);
            // image is bind and upload to respective folder

            $data2 = array(
                "iduser" => $this->input->post('iduser'),
                "judulberita" => $this->input->post('judulberita'),
                "deskripsiberita" => $this->input->post('deskripsiberita'),
                "tanggalberita" => date('Y-m-d',strtotime('now')),
                "fotoberita" => $filename,
                "linkvideoberita" => $this->input->post('linkvideoberita'),
            );

            $berita = $this->Admin_master->insert_table('tb_berita', $data2);

            $output['message'] = 'Berita berhasil di upload';
            $output['success'] = '1';

            $this->set_response($output);
        } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
   }  

}
?>