<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Informasi extends REST_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Admin_master');
    }

    public function sendyoutube_post(){
          
          $this->load->library('form_validation');

          $row = array(
              "idadmin" => $this->input->post('idadmin'),
              "judulvideo" => $this->input->post('judulvideo'),
              "linkvideo" => $this->input->post('linkvideo'),
              "deskripsivideo" => $this->input->post('deskripsivideo'),
              "tanggalupload" => date('Y-m-d',strtotime('now')),
          );

          $this->form_validation->set_data($row);
          $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
          $this->form_validation->set_rules('judulvideo', 'judulvideo', 'trim|required');
          $this->form_validation->set_rules('linkvideo', 'linkvideo', 'trim|required');
          $this->form_validation->set_rules('deskripsivideo', 'deskripsivideo', 'trim|required');

          if ($this->form_validation->run() != false) {
                
                $result = $this->Admin_master->insert_table('tb_videotutorial', $row);

                $output['message'] = 'Upload Video Sukses!';
                $output['success'] = 1;

                $this->set_response($output);
          } else {
                $this->set_response([
                  'message' => validation_errors(),
                  'success' => 0,
                ], REST_Controller::HTTP_BAD_REQUEST);
          }
                  
    }
   
    public function getlistvideo_post(){

      $this->load->library('form_validation');

      $idadmin = $this->input->post('idadmin');

      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');

      if ($this->form_validation->run() != false) {

          $sql = $this->db->query("SELECT tv.idvideotutorial,tv.judulvideo, tv.linkvideo, tv.deskripsivideo, tv.tanggalupload, tu.username FROM tb_videotutorial tv JOIN tb_user tu ON tv.idadmin = tu.iduser ORDER BY tv.tanggalupload DESC")->result_array();

          // $getData = $sql->result_array();

          $arraydataform = array();

          foreach ($sql as $value) {
            $dataform['idvideotutorial'] = $value['idvideotutorial'];
            $dataform['judulvideo'] = $value['judulvideo'];
            $dataform['linkvideo'] = $value['linkvideo'];
            $dataform['deskripsivideo'] = $value['deskripsivideo'];
            $dataform['tanggalupload'] = $value['tanggalupload'];
            $dataform['username'] = $value['username'];

            array_push($arraydataform, $dataform);
          }

          $output['message'] = 'Sukses menampilkan data!';
          $output['success'] = '1';
          $output['info'] = $arraydataform;

          $this->set_response($output);
      } else {
          $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
          ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

    public function sendinputbarang_post(){
            
        $this->load->library('form_validation');

        $row = array(
            "idadmin" => $this->input->post('idadmin'),
            "namabarang" => $this->input->post('namabarang'),
            "hargabarang" => $this->input->post('hargabarang'),
        );

        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
        $this->form_validation->set_rules('namabarang', 'namabarang', 'trim|required');
        $this->form_validation->set_rules('hargabarang', 'hargabarang', 'trim|required');

        if ($this->form_validation->run() != false) {
              
              $result = $this->Admin_master->insert_table('tb_penawaran', $row);

              $output['message'] = 'Upload Sukses!';
              $output['success'] = 1;

              $this->set_response($output);
        } else {
              $this->set_response([
                'message' => validation_errors(),
                'success' => 0,
              ], REST_Controller::HTTP_BAD_REQUEST);
        }
              
    }

    public function getlistbarang_post(){

      $this->load->library('form_validation');

      $idadmin = $this->input->post('idadmin');

      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');

      if ($this->form_validation->run() != false) {

          $sql = $this->db->query("SELECT idtbpenawaran,idadmin, namabarang, hargabarang FROM tb_penawaran ORDER BY idadmin DESC")->result_array();

          // $getData = $sql->result_array();

          $arraydataform = array();

          foreach ($sql as $value) {
            $dataform['idbarang'] = $value['idtbpenawaran'];
            $dataform['idadmin'] = $value['idadmin'];
            $dataform['namabarang'] = $value['namabarang'];
            $dataform['hargabarang'] = $value['hargabarang'];

            array_push($arraydataform, $dataform);
          }

          $output['message'] = 'Sukses menampilkan data!';
          $output['success'] = '1';
          $output['info'] = $arraydataform;

          $this->set_response($output);
      } else {
          $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
          ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

    public function kirimpenawaran_post(){
            
      $this->load->library('form_validation');

      $row = array(
          "idadmin" => $this->input->post('idadmin'),
          "iduser" => $this->input->post('iduser'),
          "pesanpenawaran" => $this->input->post('pesanpenawaran'),
          "idbarang" => $this->input->post('idbarang'),
          "hargabarang" => $this->input->post('hargabarang'),
          "tanggalpenawaran" => date('Y-m-d',strtotime('now')),
      );

      $this->form_validation->set_data($row);
      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
      $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');
      $this->form_validation->set_rules('pesanpenawaran', 'pesanpenawaran', 'trim|required');
      $this->form_validation->set_rules('idbarang', 'idbarang', 'trim|required');
      $this->form_validation->set_rules('hargabarang', 'hargabarang', 'trim|required');

      if ($this->form_validation->run() != false) {
            
            $result = $this->Admin_master->insert_table('tb_kirimpenawaran', $row);

            $output['message'] = 'Penawaran Anda Telah Terkirim!';
            $output['success'] = 1;

            $this->set_response($output);
      } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

    public function historipenawaran_post(){

      $this->load->library('form_validation');

      $idadmin = $this->input->post('idadmin');

      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');

      if ($this->form_validation->run() != false) {

          $sql = $this->db->query("SELECT tk.idkirimpenawaran, tk.idadmin, tk.iduser, tk.pesanpenawaran, tk.idbarang, tk.hargabarang, tk.tanggalpenawaran FROM tb_kirimpenawaran tk JOIN tb_user tu ON tk.idadmin = tu.iduser WHERE tk.idadmin = '$idadmin' ORDER BY tk.idadmin DESC")->result_array();

          // $getData = $sql->result_array();

          $arraydataform = array();

          foreach ($sql as $value) {
            $dataform['idpenawaran'] = $value['idkirimpenawaran'];
            $dataform['idadmin'] = $value['idadmin'];
            $dataform['idpeternak'] = $value['iduser'];
            $dataform['pesanpenawaran'] = $value['pesanpenawaran'];
            $dataform['idbarang'] = $value['idbarang'];
            $dataform['hargabarang'] = $value['hargabarang'];
            $dataform['tanggalpenawaran'] = $value['tanggalpenawaran'];

            array_push($arraydataform, $dataform);
          }

          $output['message'] = 'Sukses menampilkan data!';
          $output['success'] = '1';
          $output['info'] = $arraydataform;

          $this->set_response($output);
      } else {
          $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
          ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

    public function updatehargatelur_post(){
            
      $this->load->library('form_validation');

      $row = array(
          "idadmin" => $this->input->post('idadmin'),
          "hargatelur" => $this->input->post('hargatelur'),
          "idprovinsi" => $this->input->post('idprovinsi'),
          "idkabkota" => $this->input->post('idkabkota'),
          "tanggalupdate" => date('Y-m-d',strtotime('now')),
      );

      $this->form_validation->set_data($row);
      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
      $this->form_validation->set_rules('hargatelur', 'hargatelur', 'trim|required');
      $this->form_validation->set_rules('idprovinsi', 'idprovinsi', 'trim|required');
      $this->form_validation->set_rules('idkabkota', 'idkabkota', 'trim|required');

      if ($this->form_validation->run() != false) {
            
            $result = $this->Admin_master->insert_table('tb_hargatelur', $row);

            $output['message'] = 'Update Harga Telur Berhasil!';
            $output['success'] = 1;

            $this->set_response($output);
      } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

    public function historiupdateharga_post(){

      $this->load->library('form_validation');

      $idadmin = $this->input->post('idadmin');

      $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');

      if ($this->form_validation->run() != false) {

          $sql = $this->db->query("SELECT th.idhargatelur, th.hargatelur, p.name as provinsi, r.name as kota, th.tanggalupdate, tu.username FROM tb_hargatelur th JOIN provinces p ON th.idprovinsi = p.id JOIN regencies r ON th.idkabkota = r.id JOIN tb_user tu ON th.idadmin = tu.iduser ORDER BY th.tanggalupdate DESC")->result_array();

          $arraydataform = array();

          foreach ($sql as $value) {
            $dataform['idhargatelur'] = $value['idhargatelur'];
            $dataform['hargatelur'] = $value['hargatelur'];
            $dataform['provinsi'] = $value['provinsi'];
            $dataform['kota'] = $value['kota'];
            $dataform['tanggalupdate'] = $value['tanggalupdate'];
            $dataform['username'] = $value['username'];

            array_push($arraydataform, $dataform);
          }

          $output['message'] = 'Sukses menampilkan data!';
          $output['success'] = '1';
          $output['info'] = $arraydataform;

          $this->set_response($output);
      } else {
          $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
          ], REST_Controller::HTTP_BAD_REQUEST);
      }
    }

}
?>