<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Konsultasiadmin extends REST_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('user/Model_master');
        
    }

    public function sendchat_post(){
          
        $this->load->library('form_validation');

        $row = array(
            "idtipekonsul" => $this->input->post('idtipekonsul'),
            "idadmin" => $this->input->post('idadmin'),
            "idpeternak" => $this->input->post('idpeternak'),
            "chat" => $this->input->post('chat'),
            "tanggal" => date('Y-m-d',strtotime('now')),
            "sender" => 'ADMIN',
        );

        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idtipekonsul', 'idtipekonsul', 'trim|required');
        $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
        $this->form_validation->set_rules('idpeternak', 'idpeternak', 'trim|required');
        $this->form_validation->set_rules('chat', 'chat', 'trim|required');

        if ($this->form_validation->run() != false) {
              
              $result = $this->Model_master->insert_table('tb_konsultasi', $row);

              $output['message'] = 'Chat Sukses!';
              $output['success'] = 1;

              $this->set_response($output);
        } else {
              $this->set_response([
                'message' => validation_errors(),
                'success' => 0,
              ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function sendchatimage_post(){
          
        $this->load->library('form_validation');

        $row = array(
            "idtipekonsul" => $this->input->post('idtipekonsul'),
            "idadmin" => $this->input->post('idadmin'),
            "idpeternak" => $this->input->post('idpeternak'),
            "tanggal" => date('Y-m-d',strtotime('now')),
            "sender" => 'ADMIN',
            "gambar" => $this->input->post('gambar'),
        );

        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idtipekonsul', 'idtipekonsul', 'trim|required');
        $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
        $this->form_validation->set_rules('idpeternak', 'idpeternak', 'trim|required');

        if ($this->form_validation->run() != false) {

            //Upload Foto
            $image = base64_decode($this->input->post("gambar"));

            $image_name = md5(uniqid(rand(), true));

            // $jembut = $image_name . '.' . 'png';
            $filename = $image_name . '.' . 'png';
            //rename file name with random number
            $path = "../../upload/image/".$filename;
            //image uploading folder path

            file_put_contents($path, $image);
            // image is bind and upload to respective folder

            $data = array(
                "idtipekonsul" => $row['idtipekonsul'],
                "idadmin" => $row['idadmin'],
                "idpeternak" => $row['idpeternak'],
                "tanggal" => date('Y-m-d',strtotime('now')),
                "sender" => 'ADMIN',
                "gambar" => $filename,
            );
              
            $result = $this->Model_master->insert_table('tb_konsultasi', $data);

            if($result != 0){
                $output['message'] = 'Chat Sukses!';
                $output['success'] = 1;

                $this->set_response($output);
            } else{
                $output['message'] = 'Chat Gagal!';
                $output['success'] = 0;

                $this->set_response($output);
            }
            
        } else {
            $this->set_response([
                'message' => validation_errors(),
                'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getlistchat_post(){

        $this->load->library('form_validation');
  
        // $idadmin = $this->input->post('idadmin');
        $idpeternak = $this->input->post('idpeternak');
        $idtipekonsul = $this->input->post("idtipekonsul");
  
        // $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
        $this->form_validation->set_rules('idpeternak', 'idpeternak', 'trim|required');
        $this->form_validation->set_rules('idtipekonsul', 'idtipekonsul', 'trim|required');
  
        if ($this->form_validation->run() != false) {
  
            $sql = $this->db->query("SELECT * FROM tb_konsultasi WHERE idtipekonsul = '$idtipekonsul' AND idpeternak = '$idpeternak' ORDER BY idkonsultasi")->result_array();
  
            // $getData = $sql->result_array();
  
            $arraydataform = array();
  
            foreach ($sql as $value) {
              $dataform['tanggal'] = $value['tanggal'];
              $dataform['chat'] = $value['chat'];
              if($value['sender'] == "ADMIN"){
                  $dataform['kiri'] = 0;
              } else {
                  $dataform['kiri'] = 1;
              }

              if($value['gambar'] == ""){
                $dataform['gambar'] = $value['gambar'];
              } else{
                $dataform['gambar'] = "http://izharuddin1997.com/upload/image/".$value['gambar'];
              }
  
              array_push($arraydataform, $dataform);
            }
  
            $output['message'] = 'Sukses menampilkan data!';
            $output['success'] = '1';
            $output['info'] = $arraydataform;
  
            $this->set_response($output);
        } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getlistuserbytipe_post(){

        $this->load->library('form_validation');
  
        // $idadmin = $this->input->post('idadmin');
        $idtipekonsul = $this->input->post("idtipekonsul");
  
        // $this->form_validation->set_rules('idadmin', 'idadmin', 'trim|required');
        $this->form_validation->set_rules('idtipekonsul', 'idtipekonsul', 'trim|required');
  
        if ($this->form_validation->run() != false) {
  
            $sql = $this->db->query("SELECT tk.idpeternak, tu.namalengkap, tk.tanggal FROM tb_konsultasi tk JOIN tb_user tu ON tk.idpeternak = tu.iduser WHERE tk.idtipekonsul = '$idtipekonsul' GROUP BY tk.idpeternak ORDER BY tk.idkonsultasi")->result_array();
  
            // $getData = $sql->result_array();
  
            $arraydataform = array();
  
            foreach ($sql as $value) {
              $dataform['idpeternak'] = $value['idpeternak'];
              $dataform['namalengkap'] = $value['namalengkap'];
              $dataform['tanggal'] = $value['tanggal'];
  
              array_push($arraydataform, $dataform);
            }
  
            $output['message'] = 'Sukses menampilkan data!';
            $output['success'] = '1';
            $output['info'] = $arraydataform;
  
            $this->set_response($output);
        } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }
}
?>