<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Checkout extends REST_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('user/Model_master');
    }

    public function checkout_post(){
        
        $this->load->library('form_validation');

        $data = array(
            "idoutlet" => $this->input->post('idoutlet'),
            "idkasir" => $this->input->post('idkasir'),
            "idpelanggan" => $this->input->post('idpelanggan'),
            "iddiskontrans" => $this->input->post('iddiskontrans'),
            "nilaidiskon" => $this->input->post('nilaidiskon'),
            "idtipepembayaran" => $this->input->post('idtipepembayaran'),
            "istunai" => $this->input->post('istunai'),
            "totaltrans" => $this->input->post('totaltrans'),
            "jumlahdibayar" => $this->input->post('jumlahdibayar'),
            "datetrans" => date('Y-m-d H:i:s', strtotime('now')),
            "statusrefund" => $this->input->post('statusrefund'),
            "statusdibayar" => $this->input->post('statusdibayar'),
            "listitem" => $this->input->post('listitem'),
        );

        $str_result = '1234567890'; 
        $kodeacak = substr(str_shuffle($str_result), 0, 8);

        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('idkasir', 'idkasir', 'trim|required');

        $json_value = $this->input->post('listitem');

        if ($this->form_validation->run() != false) {

            $datatrans = array(
                "kodetransaksi" => "Trx-".$kodeacak,
                "idoutlet" => $this->input->post('idoutlet'),
                "idkasir" => $this->input->post('idkasir'),
                "idpelanggan" => $this->input->post('idpelanggan'),
                "iddiskontrans" => $this->input->post('iddiskontrans'),
                "nilaidiskon" => $this->input->post('nilaidiskon'),
                "idtipepembayaran" => $this->input->post('idtipepembayaran'),
                "istunai" => $this->input->post('istunai'),
                "totaltrans" => $this->input->post('totaltrans'),
                "jumlahdibayar" => $this->input->post('jumlahdibayar'),
                "datetrans" => date('Y-m-d H:i:s', strtotime('now')),
                "statusrefund" => $this->input->post('statusrefund'),
                "statusdibayar" => $this->input->post('statusdibayar'),
            );

            $result = $this->Model_master->insert_table('tb_transheader', $datatrans);

            $lastID = $this->db->insert_id();

            $jsonarray = json_decode($json_value,true);
    
            foreach($jsonarray as $item){
              $dataitem = array(
                  "idtransHD" => $lastID,
                  "iditem" => $item['iditem'],
                  "jumlahitem" => $item['jumlahitem'],
                  "hargaitem" => $item['hargaitem'],
                  "iddiskonitem" => $item['iddiskonitem'],
                  "nilaidiskon" => $item['nilaidiskon'],
                  "hargaitemdiskon" => $item['hargaitemdiskon'],
              );
      
              $translist = $this->Model_master->insert_table('tb_translist', $dataitem);
            }

            $transaksi['notransaksi'] = "Trx-".$kodeacak;

            $output['message'] = 'Transaksi berhasil';
            $output['success'] = 1;
            $output['data'] = $transaksi;
            $this->set_response($output);

        } else {
          $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
          ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function historitransaksi_post(){

        $this->load->library('form_validation');
  
        $idoutlet = $this->input->post('idoutlet');
  
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
  
        if ($this->form_validation->run() != false) {
  
            $this->db->select('tb_transheader.*');
            $this->db->from('tb_transheader');
            $this->db->where('tb_transheader.idoutlet', $idoutlet);
            $this->db->order_by('tb_transheader.idtransheader DESC');
            $getransaksi = $this->db->get()->result_array();
  
            $arrtransaksi = array();
  
            foreach ($getransaksi as $value) {
              $trans['idtransheader'] = $value['idtransheader'];
              $trans['kodetransaksi'] = $value['kodetransaksi'];

              $this->db->select('tb_outlet.*');
              $this->db->from('tb_outlet');
              $this->db->where('tb_outlet.idoutlet', $value['idoutlet']);
              $getoutlet = $this->db->get()->row();

              $trans['namaoutlet'] = $getoutlet->namaoutlet;

              $this->db->select('tb_kasir.*');
              $this->db->from('tb_kasir');
              $this->db->where('tb_kasir.idkasir', $value['idkasir']);
              $getkasir = $this->db->get()->row();

              $trans['namakasir'] = $getkasir->username;

              $this->db->select('tb_pelanggan.*');
              $this->db->from('tb_pelanggan');
              $this->db->where('tb_pelanggan.idpelanggan', $value['idpelanggan']);
              $getpelanggan = $this->db->get()->row();

              if($getpelanggan) {
                $trans['namapelanggan'] = $getpelanggan->namapelanggan;
              } else {
                $trans['namapelanggan'] = "-";
              }

              $trans['datetrans'] = $value['datetrans'];
              $trans['totaltrans'] = $value['totaltrans'];
              $trans['jumlahdibayar'] = $value['jumlahdibayar'];
              $trans['statusrefund'] = $value['statusrefund'];
              $trans['statusdibayar'] = $value['statusdibayar'];
              if($value['istunai'] == "1") {
                $trans['tipepembayaran'] = "Tunai";
              } else {

                $this->db->select('tb_tipepembayaran.*');
                $this->db->from('tb_tipepembayaran');
                $this->db->where('tb_tipepembayaran.idbisnis', $getoutlet->idbisnis);
                $this->db->where('tb_tipepembayaran.idtipepembayaran', $value['idtipepembayaran']);
                $namapembayaran = $this->db->get()->row();

                $trans['tipepembayaran'] = $namapembayaran->namatipepembayaran;
              }

              $this->db->select('tb_translist.*');
              $this->db->from('tb_translist');
              $this->db->where('tb_translist.idtransHD', $value['idtransheader']);
              $gettranslist = $this->db->get()->result_array();

              $arrItem = array();

              foreach($gettranslist as $values) {
                $this->db->select('tb_item.*');
                $this->db->from('tb_item');
                $this->db->where('tb_item.iditem', $values['iditem']);
                $getiitem = $this->db->get()->row();

                $item['namaitem'] = $getiitem->namaitem;
                $item['hargaitem'] = $getiitem->hargaitem;
                $item['jumlahitem'] = $values['jumlahitem'];

                array_push($arrItem, $item);
              }

              $trans['itemlist'] = $arrItem;
  
              array_push($arrtransaksi, $trans);
            }
  
            $output['message'] = 'Sukses menampilkan histori transaksi!';
            $output['success'] = '1';
            $output['data'] = $arrtransaksi;
  
            $this->set_response($output);
        } else {
            $this->set_response([
              'message' => validation_errors(),
              'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
?>