<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Item extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function buatkategoriitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "namakategori" => $this->input->post('namakategori'),
            "statushapus" => '0',
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('namakategori', 'namakategori', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $row2 = array(
                "idbisnis" => $this->input->post('idbisnis'),
                "idoutlet" => $this->input->post('idoutlet'),
                "namakategori" => $this->input->post('namakategori'),
                "statushapus" => '0',
            );

            $kategoriitem = $this->Model_master->insert_table('tb_kategoriitem', $row2);
            
            $output['message'] = "Berhasil Tambah Kategori Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editkategoriitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idkategoriitem" => $this->input->post('idkategoriitem'),
            "idoutlet" => $this->input->post('idoutlet'),
            "namakategori" => $this->input->post('namakategori'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('namakategori', 'namakategori', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $kategoriitem = $this->db->query("UPDATE tb_kategoriitem SET namakategori = '$row[namakategori]' WHERE idoutlet = '$row[idoutlet]' AND idkategoriitem = '$row[idkategoriitem]'");
            
            $output['message'] = "Berhasil Ubah Kategori Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function listkategoriitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_kategoriitem.*');
            $this->db->from('tb_kategoriitem');
            $this->db->where('tb_kategoriitem.idbisnis', $row['idbisnis']);
            $this->db->where('tb_kategoriitem.statushapus', '0');
            $this->db->order_by('tb_kategoriitem.idkategoriitem DESC');
            $getlistkategori = $this->db->get()->result_array();

            $arrListKategori = array();

            foreach($getlistkategori as $value){
                $kategori['idkategoriitem'] = $value['idkategoriitem'];
                $kategori['idoutlet'] = $value['idoutlet'];
                
                $this->db->select('tb_outlet.*');
                $this->db->from('tb_outlet');
                $this->db->where('tb_outlet.idoutlet', $value['idoutlet']);
                $getOutlet = $this->db->get()->row();
                $kategori['namaoutlet'] = $getOutlet->namaoutlet;
                $kategori['namakategori'] = $value['namakategori'];

                if($value['statushapus'] == "0"){
                    $kategori['status'] = "Tersedia";
                } else {
                    $kategori['status'] = "Terhapus";
                }

                array_push($arrListKategori, $kategori);
            }
            
            $output['message'] = "Berhasil Menampilkan Kategori Item!";
            $output['success'] = 1;
            $output['data'] = $arrListKategori;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function listkategoriitembyoutlet_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_kategoriitem.*');
            $this->db->from('tb_kategoriitem');
            $this->db->where('tb_kategoriitem.idbisnis', $row['idbisnis']);
            $this->db->where('tb_kategoriitem.idoutlet', $row['idoutlet']);
            $this->db->where('tb_kategoriitem.statushapus', '0');
            $this->db->order_by('tb_kategoriitem.idkategoriitem DESC');
            $getlistkategori = $this->db->get()->result_array();

            $arrListKategori = array();

            foreach($getlistkategori as $value){
                $kategori['idkategoriitem'] = $value['idkategoriitem'];
                $kategori['idoutlet'] = $value['idoutlet'];
                
                $this->db->select('tb_outlet.*');
                $this->db->from('tb_outlet');
                $this->db->where('tb_outlet.idoutlet', $value['idoutlet']);
                $getOutlet = $this->db->get()->row();
                $kategori['namaoutlet'] = $getOutlet->namaoutlet;
                $kategori['namakategori'] = $value['namakategori'];

                if($value['statushapus'] == "0"){
                    $kategori['status'] = "Tersedia";
                } else {
                    $kategori['status'] = "Terhapus";
                }

                array_push($arrListKategori, $kategori);
            }
            
            $output['message'] = "Berhasil Menampilkan Kategori Item!";
            $output['success'] = 1;
            $output['data'] = $arrListKategori;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function hapuskategoriitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idkategoriitem" => $this->input->post('idkategoriitem'),
            "idoutlet" => $this->input->post('idoutlet'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('idkategoriitem', 'idkategoriitem', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $kategoriitem = $this->db->query("UPDATE tb_kategoriitem SET statushapus = '1' WHERE idoutlet = '$row[idoutlet]' AND idkategoriitem = '$row[idkategoriitem]'");
            
            $output['message'] = "Berhasil Hapus Kategori Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function buatitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "idkategoriitem" => $this->input->post('idkategoriitem'),
            "namaitem" => $this->input->post('namaitem'),
            "hargaitem" => $this->input->post('hargaitem'),
            "stok" => $this->input->post('stok'),
            "fotoitem" => $this->input->post('fotoitem'),
            "statushapus" => "0",
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('namaitem', 'namaitem', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $imageitem = base64_decode($this->input->post("fotoitem"));
            $image_nameitem = md5(uniqid(rand(), true));
            $filenameitem = $image_nameitem . '.'. 'png';
            $pathimage = "./assets/uploads/".$filenameitem;
            file_put_contents($pathimage, $imageitem);

            $row2 = array(
                "idbisnis" => $this->input->post('idbisnis'),
                "idoutlet" => $this->input->post('idoutlet'),
                "idkategoriitem" => $this->input->post('idkategoriitem'),
                "namaitem" => $this->input->post('namaitem'),
                "hargaitem" => $this->input->post('hargaitem'),
                "stok" => $this->input->post('stok'),
                "fotoitem" => $filenameitem,
                "statushapus" => "0",
            );

            $kategoriitem = $this->Model_master->insert_table('tb_item', $row2);
            
            $output['message'] = "Berhasil Tambah Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function edititem_post(){
        $this->load->library('form_validation');

        $row = array(
            "iditem" => $this->input->post('iditem'),
            "idoutlet" => $this->input->post('idoutlet'),
            "idkategoriitem" => $this->input->post('idkategoriitem'),
            "namaitem" => $this->input->post('namaitem'),
            "hargaitem" => $this->input->post('hargaitem'),
            "stok" => $this->input->post('stok'),
            "statushapus" => "0",
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('namaitem', 'namaitem', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $kategoriitem = $this->db->query("UPDATE tb_item SET namaitem = '$row[namaitem]', idkategoriitem = '$row[idkategoriitem]', hargaitem = '$row[hargaitem]', stok = '$row[stok]' WHERE idoutlet = '$row[idoutlet]' AND iditem = '$row[iditem]'");
            
            $output['message'] = "Berhasil Ubah Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function listitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_item.*');
            $this->db->from('tb_item');
            $this->db->where('tb_item.idbisnis', $row['idbisnis']);
            $this->db->where('tb_item.statushapus', '0');
            $this->db->order_by('tb_item.iditem DESC');
            $getlistitem = $this->db->get()->result_array();

            $arrListItem = array();

            foreach($getlistitem as $value){
                $item['iditem'] = $value['iditem'];
                $item['idoutlet'] = $value['idoutlet'];
                
                $this->db->select('tb_outlet.*');
                $this->db->from('tb_outlet');
                $this->db->where('tb_outlet.idoutlet', $value['idoutlet']);
                $getOutlet = $this->db->get()->row();
                $item['namaoutlet'] = $getOutlet->namaoutlet;
          
                $this->db->select('tb_kategoriitem.*');
                $this->db->from('tb_kategoriitem');
                $this->db->where('tb_kategoriitem.idkategoriitem', $value['idkategoriitem']);
                $getKategori = $this->db->get()->row();
                $item['namakategori'] = $getKategori->namakategori;
                $item['namaitem'] = $value['namaitem'];
                $item['hargaitem'] = $value['hargaitem'];
                $item['stok'] = $value['stok'];
                $item['fotoitem'] = base_url()."apici/assets/uploads/".$value['fotoitem'];

                if($value['statushapus'] == "0"){
                    $item['status'] = "Tersedia";
                } else {
                    $item['status'] = "Terhapus";
                }

                array_push($arrListItem, $item);
            }
            
            $output['message'] = "Berhasil Menampilkan Item!";
            $output['success'] = 1;
            $output['data'] = $arrListItem;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function listitembykategori_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "idkategoriitem" => $this->input->post('idkategoriitem'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('idkategoriitem', 'idkategoriitem', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_item.*');
            $this->db->from('tb_item');
            $this->db->where('tb_item.idbisnis', $row['idbisnis']);
            $this->db->where('tb_item.idoutlet', $row['idoutlet']);
            $this->db->where('tb_item.idkategoriitem', $row['idkategoriitem']);
            $this->db->where('tb_item.statushapus', '0');
            $this->db->order_by('tb_item.iditem DESC');
            $getlistitem = $this->db->get()->result_array();

            $arrListItem = array();

            foreach($getlistitem as $value){
                $item['iditem'] = $value['iditem'];
                $item['idoutlet'] = $value['idoutlet'];
                
                $this->db->select('tb_outlet.*');
                $this->db->from('tb_outlet');
                $this->db->where('tb_outlet.idoutlet', $value['idoutlet']);
                $getOutlet = $this->db->get()->row();
                $item['namaoutlet'] = $getOutlet->namaoutlet;
          
                $this->db->select('tb_kategoriitem.*');
                $this->db->from('tb_kategoriitem');
                $this->db->where('tb_kategoriitem.idkategoriitem', $value['idkategoriitem']);
                $getKategori = $this->db->get()->row();
                $item['namakategori'] = $getKategori->namakategori;
                $item['namaitem'] = $value['namaitem'];
                $item['hargaitem'] = $value['hargaitem'];
                $item['stok'] = $value['stok'];
                $item['fotoitem'] = base_url()."apici/assets/uploads/".$value['fotoitem'];

                if($value['statushapus'] == "0"){
                    $item['status'] = "Tersedia";
                } else {
                    $item['status'] = "Terhapus";
                }

                array_push($arrListItem, $item);
            }
            
            $output['message'] = "Berhasil Menampilkan Item!";
            $output['success'] = 1;
            $output['data'] = $arrListItem;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function hapusitem_post(){
        $this->load->library('form_validation');

        $row = array(
            "iditem" => $this->input->post('iditem'),
            "idoutlet" => $this->input->post('idoutlet'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');
        $this->form_validation->set_rules('iditem', 'iditem', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $kategoriitem = $this->db->query("UPDATE tb_item SET statushapus = '1' WHERE idoutlet = '$row[idoutlet]' AND iditem = '$row[iditem]'");
            
            $output['message'] = "Berhasil Hapus Item!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }
}
