<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Kasir extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function buatkasir_post(){
        $this->load->library('form_validation');

        $row = array(
            "idowner" => $this->input->post('idowner'),
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "username" => $this->input->post('username'),
            "password" => $this->input->post('password'),
            "statushapus" => '0',
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("INSERT INTO tb_kasir(idowner, idbisnis, idoutlet, username, password, statushapus) VALUES('$row[idowner]', '$row[idbisnis]', '$row[idoutlet]', '$row[username]', '$row[password]', '$row[statushapus]') ");
            
            $output['message'] = "Berhasil Tambah Kasir!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getlistkasir_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_kasir.*, tb_outlet.namaoutlet as namaoutlet');
            $this->db->from('tb_kasir');
            $this->db->join('tb_outlet', 'tb_kasir.idoutlet = tb_outlet.idoutlet');
            $this->db->where('tb_kasir.idbisnis', $idbisnis);
            $this->db->where('tb_kasir.statushapus', '0');
            $result=$this->db->get()->result_array();

            $kasirArr = array();

            foreach($result as $value) {
                $kasir['idkasir'] = $value['idkasir'];
                $kasir['username'] = $value['username'];
                $kasir['namaoutlet'] = $value['namaoutlet'];
                $kasir['password'] = $value['password'];
                $kasir['idoutlet'] = $value['idoutlet'];

                array_push($kasirArr, $kasir);
            }
            
            $output['message'] = "Berhasil Menampilkan Kasir!";
            $output['success'] = 1;
            $output['data'] = $kasirArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editkasir_post(){
        $this->load->library('form_validation');

        $row = array(
            "idowner" => $this->input->post('idowner'),
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "username" => $this->input->post('username'),
            "password" => $this->input->post('password'),
            "statushapus" => '0',
            "idkasir" => $this->input->post('idkasir'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("UPDATE tb_kasir SET username = '$row[username]', password = '$row[password]', idoutlet = '$row[idoutlet]' WHERE idowner = '$row[idowner]' AND idbisnis = '$row[idbisnis]' AND idkasir = '$row[idkasir]' ");
            
            $output['message'] = "Berhasil Edit Kasir!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
