<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Outlet extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function buatoutlet_post(){
        $this->load->library('form_validation');

        $row = array(
            "idowner" => $this->input->post('idowner'),
            "idbisnis" => $this->input->post('idbisnis'),
            "namaoutlet" => $this->input->post('namaoutlet'),
            "idprovinsi" => $this->input->post('idprovinsi'),
            "idkabupaten" => $this->input->post('idkabupaten'),
            "idkecamatan" => $this->input->post('idkecamatan'),
            "statushapus" => '0',
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("INSERT INTO tb_outlet(idowner, idbisnis, namaoutlet, idprovinsi, idkabupaten, idkecamatan, statushapus) VALUES('$row[idowner]', '$row[idbisnis]', '$row[namaoutlet]', '$row[idprovinsi]', '$row[idkabupaten]', '$row[idkecamatan]', '$row[statushapus]') ");
            
            $output['message'] = "Berhasil Tambah Outlet!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getlistoutlet_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_outlet.idoutlet, tb_outlet.namaoutlet, tb_outlet.idprovinsi, tb_outlet.idkabupaten, tb_outlet.idkecamatan, provinces.name as namaprovinsi, regencies.name as namakabupaten, districts.name as namakecamatan');
            $this->db->from('tb_outlet');
            $this->db->join('provinces', 'tb_outlet.idprovinsi = provinces.id');
            $this->db->join('regencies', 'tb_outlet.idkabupaten = regencies.id');
            $this->db->join('districts', 'tb_outlet.idkecamatan = districts.id');
            $this->db->where('tb_outlet.idbisnis', $idbisnis);
            $this->db->where('tb_outlet.idowner', $idowner);
            $this->db->where('tb_outlet.statushapus', '0');
            $result=$this->db->get()->result_array();

            $outletArr = array();

            foreach($result as $value) {
                $outlet['idoutlet'] = $value['idoutlet'];
                $outlet['namaoutlet'] = $value['namaoutlet'];
                $outlet['idprovinsi'] = $value['idprovinsi'];
                $outlet['namaprovinsi'] = $value['namaprovinsi'];
                $outlet['idkabupaten'] = $value['idkabupaten'];
                $outlet['namakabupaten'] = $value['namakabupaten'];
                $outlet['idkecamatan'] = $value['idkecamatan'];
                $outlet['namakecamatan'] = $value['namakecamatan'];

                array_push($outletArr, $outlet);
            }
            
            $output['message'] = "Berhasil Menampilkan Outlet!";
            $output['success'] = 1;
            $output['data'] = $outletArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editoutlet_post(){
        $this->load->library('form_validation');

        $row = array(
            "idowner" => $this->input->post('idowner'),
            "idbisnis" => $this->input->post('idbisnis'),
            "idoutlet" => $this->input->post('idoutlet'),
            "namaoutlet" => $this->input->post('namaoutlet'),
            "idprovinsi" => $this->input->post('idprovinsi'),
            "idkabupaten" => $this->input->post('idkabupaten'),
            "idkecamatan" => $this->input->post('idkecamatan'),
            "statushapus" => '0',
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idoutlet', 'idoutlet', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("UPDATE tb_outlet SET namaoutlet = '$row[namaoutlet]', idprovinsi = '$row[idprovinsi]', idkabupaten = '$row[idkabupaten]', idkecamatan = '$row[idkecamatan]' WHERE idowner = '$row[idowner]' AND idbisnis = '$row[idbisnis]' AND idoutlet = '$row[idoutlet]' ");
            
            $output['message'] = "Berhasil Edit Outlet!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
