<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Payment extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function getpaymentmetode_post(){
        $this->load->library('form_validation');

        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("SELECT * FROM tb_tipepembayaran WHERE idbisnis = '$idbisnis'")->result_array();
            $payArr = array();

            foreach($sql as $value){

                $pay['idtipepembayaran'] = $value['idtipepembayaran'];
                $pay['namatipepembayaran'] = $value['namatipepembayaran'];
                $pay['statusaktif'] = $value['statusaktif'];

                array_push($payArr, $pay);
            }
            
            $output['message'] = "Berhasil Menampilkan Payment!";
            $output['success'] = 1;
            $output['data'] = $payArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getpaymenttunai_post(){
        $this->load->library('form_validation');

        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("SELECT * FROM tb_paymenttunai")->result_array();
            $payArr = array();

            foreach($sql as $value){

                $pay['idtunai'] = $value['idtunai'];
                $pay['nominaltunai'] = $value['nominaltunai'];

                array_push($payArr, $pay);
            }
            
            $output['message'] = "Berhasil Menampilkan Payment Tunai!";
            $output['success'] = 1;
            $output['data'] = $payArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function updatestatuspayment_post(){
        $this->load->library('form_validation');

        $idbisnis = $this->input->post('idbisnis');
        $idpayment = $this->input->post('idpayment');
        $statuspayment = $this->input->post('statusaktif');
        
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');
        $this->form_validation->set_rules('idpayment', 'idpayment', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $update = $this->db->query("UPDATE tb_tipepembayaran SET statusaktif = '$statuspayment' WHERE idbisnis = '$idbisnis' AND idtipepembayaran = '$idpayment'");
            
            $output['message'] = "Update status berhasil!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function bayarbilling_post(){
        $this->load->library('form_validation');

        $str_result = '1234567890'; 
        $kodeacak = substr(str_shuffle($str_result), 0, 12);

        $data = array(
            "kodebilling" => $kodeacak,
            "iddosen" => $this->input->post('iddosen'),
            "idpay" => $this->input->post('idpay'),
            "idpaket" => $this->input->post('idpaket'),
            "totalbill" => $this->input->post('totalbill'),
            "datebill" => date('y-m-d H:i:s', strtotime('now')),
            "overdue_date" => date('y-m-d H:i:s', strtotime('+2 days', strtotime('now'))),
        );
        
        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('kodebilling', 'kodebilling', 'trim|required');
        $this->form_validation->set_rules('iddosen', 'iddosen', 'trim|required');
        $this->form_validation->set_rules('idpay', 'idpay', 'trim|required');
        $this->form_validation->set_rules('idpaket', 'idpaket', 'trim|required');
        $this->form_validation->set_rules('totalbill', 'totalbill', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $result = $this->Model_master->insert_table('tb_billing', $data);

            $lastid = $this->db->insert_id();
            $getkode = $this->db->query("SELECT kodebilling FROM tb_billing WHERE idbilling = '$lastid'")->row();
            
            $output['message'] = "Pembayaran Telah Berhasil Dilakukan!";
            $output['success'] = 1;
            $output['kodeTrans'] = $getkode->kodebilling;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function gethistoribilling_post(){
        $this->load->library('form_validation');

        $iduser = $this->input->post('iduser');
        
        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("SELECT tbill.idbilling, tbill.kodebilling, tbill.iddosen, tdosen.namalengkap, tpay.namapay, tbill.totalbill, tbill.datebill, tbill.statusbill FROM tb_billing tbill JOIN tb_userdosen tdosen ON tbill.iddosen = tdosen.iddosen JOIN tb_paymentmetod tpay ON tbill.idpay = tpay.idpaymetode WHERE tbill.iddosen = '$iduser' ORDER BY tbill.idbilling DESC")->result_array();
            $billArr = array();

            foreach($sql as $value){

                $bill['idbilling'] = $value['idbilling'];
                $bill['kodebilling'] = $value['kodebilling'];
                $bill['iddosen'] = $value['iddosen'];
                $bill['namadosen'] = $value['namalengkap'];
                $bill['namapay'] = $value['namapay'];
                $bill['totalbill'] = $value['totalbill'];
                $bill['datebill'] = $value['datebill'];

                if($value['statusbill'] == "0"){
                    $bill['statusbill'] = "Pending";
                } else{
                    $bill['statusbill'] = "Sukses";
                }

                array_push($billArr, $bill);
            }
            
            $output['message'] = "Berhasil Menampilkan Histori Billing!";
            $output['success'] = 1;
            $output['info'] = $billArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getdetailhistoribilling_post(){
        $this->load->library('form_validation');

        $iduser = $this->input->post('iduser');
        $idbilling = $this->input->post('idbilling');
        
        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');
        $this->form_validation->set_rules('idbilling', 'idbilling', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("SELECT tbill.idbilling, tbill.kodebilling, tbill.iddosen, tdosen.namalengkap, tpay.namapay, tpaket.namapaket, tbill.totalbill, tbill.datebill, tbill.overdue_date, tbill.statusbill FROM tb_billing tbill JOIN tb_userdosen tdosen ON tbill.iddosen = tdosen.iddosen JOIN tb_paymentmetod tpay ON tbill.idpay = tpay.idpaymetode JOIN tb_paketuser tpaket ON tbill.idpaket = tpaket.idpaketuser WHERE tbill.iddosen = '$iduser' AND tbill.idbilling = '$idbilling'")->result_array();
            $billArr = array();

            foreach($sql as $value){

                $bill['idbilling'] = $value['idbilling'];
                $bill['kodebilling']= $value['kodebilling'];
                $bill['iddosen'] = $value['iddosen'];
                $bill['namadosen'] = $value['namalengkap'];
                $bill['namapay'] = $value['namapay'];
                $bill['namapaket'] = $value['namapaket'];
                $bill['totalbill'] = $value['totalbill'];
                $bill['datebill'] = $value['datebill'];
                $bill['overduedate'] = $value['overdue_date'];

                if($value['statusbill'] == "0"){
                    $bill['statusbill'] = "Pending";
                } else{
                    $bill['statusbill'] = "Sukses";
                }

                array_push($billArr, $bill);
            }
            
            $output['message'] = "Berhasil Menampilkan Detail Histori Billing!";
            $output['success'] = 1;
            $output['info'] = $billArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function uploadbuktipembayaran_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbilling" => $this->input->post('idbilling'),
            "iduser" => $this->input->post('iduser'),
            "namapengirim" => $this->input->post('namapengirim'),
            "bankpengirim" => $this->input->post('bankpengirim'),
            "tanggaltransfer" => $this->input->post('tanggaltransfer'),
            "filetransfer" => $this->input->post('filetransfer'),
            "statustransfer" => $this->input->post('statustransfer'),
            "create_at" => date('Y-m-d H:i:s',strtotime('now')),
        ); 
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbilling', 'idbilling', 'trim|required');
        $this->form_validation->set_rules('namapengirim', 'namapengirim', 'trim|required');
        $this->form_validation->set_rules('bankpengirim', 'bankpengirim', 'trim|required');
        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');

        if ( $this->form_validation->run() !== false ) {

            $config['upload_path']          = '../../fileuploadapps/';
            $config['allowed_types']        = 'pdf|docx|xlsx|pptx|doc|xls|ppt';
            $config['max_size']             = 3000;
            $this->upload->initialize($config);
            $this->load->library('upload', $config);

            if ($this->upload->do_upload('filetransfer')){
                $row = array(
                    "idbilling" => $this->input->post('idbilling'),
                    "iduser" => $this->input->post('iduser'),
                    "namapengirim" => $this->input->post('namapangirim'),
                    "bankpengirim" => $this->input->post('bankpengirim'),
                    "tanggaltransfer" => $this->input->post('tanggaltransfer'),
                    "filetransfer" => $this->upload->data('file_name'),
                    "statustransfer" => $this->input->post('statustransfer'),
                    "create_at" => date('Y-m-d H:i:s',strtotime('now')),
                );
                
                $result = $this->Model_master->insert_table('tb_buktipembayaran', $row);
                $output['message'] = "Bukti Pembayaran Berhasil Dikirim";
                $output['success'] = 1;
                $this->set_response($output);
            }
            
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    
    }

}
