<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Pelanggan extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function buatpelanggan_post(){
        $this->load->library('form_validation');

        $row = array(
            "idbisnis" => $this->input->post('idbisnis'),
            "namapelanggan" => $this->input->post('namapelanggan'),
            "email" => $this->input->post('email'),
            "notelepon" => $this->input->post('notelepon'),
            "tanggallahir" => $this->input->post('tanggallahir'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $row2 = array(
                "idbisnis" => $this->input->post('idbisnis'),
                "namapelanggan" => $this->input->post('namapelanggan'),
                "email" => $this->input->post('email'),
                "notelepon" => $this->input->post('notelepon'),
                "tanggallahir" => $this->input->post('tanggallahir'),
            );

            $result = $this->Model_master->insert_table('tb_pelanggan', $row2);
            
            $output['message'] = "Berhasil Tambah Pelanggan!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getlistpelanggan_post(){
        $this->load->library('form_validation');

        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_pelanggan.*');
            $this->db->from('tb_pelanggan');
            $this->db->where('tb_pelanggan.idbisnis', $idbisnis);
            $this->db->where('tb_pelanggan.statushapus', '0');
            $result=$this->db->get()->result_array();

            $pelangganArr = array();

            foreach($result as $value) {
                $pelanggan['idpelanggan'] = $value['idpelanggan'];
                $pelanggan['namapelanggan'] = $value['namapelanggan'];
                $pelanggan['email'] = $value['email'];
                $pelanggan['notelepon'] = $value['notelepon'];
                $pelanggan['tanggallahir'] = $value['tanggallahir'];

                array_push($pelangganArr, $pelanggan);
            }
            
            $output['message'] = "Berhasil Menampilkan Pelanggan!";
            $output['success'] = 1;
            $output['data'] = $pelangganArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editpelanggan_post(){
        $this->load->library('form_validation');

        $row = array(
            "idpelanggan" => $this->input->post('idpelanggan'),
            "idbisnis" => $this->input->post('idbisnis'),
            "namapelanggan" => $this->input->post('namapelanggan'),
            "email" => $this->input->post('email'),
            "notelepon" => $this->input->post('notelepon'),
            "tanggallahir" => $this->input->post('tanggallahir'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("UPDATE tb_pelanggan SET namapelanggan = '$row[namapelanggan]', email = '$row[email]', notelepon = '$row[notelepon]', tanggallahir = '$row[tanggallahir]' WHERE idbisnis = '$row[idbisnis]' AND idpelanggan = '$row[idpelanggan]' ");
            
            $output['message'] = "Berhasil Edit Pelanggan!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function hapuspelanggan_post(){
        $this->load->library('form_validation');

        $row = array(
            "idpelanggan" => $this->input->post('idpelanggan'),
        );
        
        $this->form_validation->set_data($row);
        $this->form_validation->set_rules('idpelanggan', 'idpelanggan', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("UPDATE tb_pelanggan SET statushapus = '1' WHERE idpelanggan = '$row[idpelanggan]' ");
            
            $output['message'] = "Berhasil Hapus Pelanggan!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
