<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Profile extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function getprofileowner_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('*');
            $this->db->from('tb_owner');
            $this->db->where('tb_owner.idowner', $idowner);
            $result=$this->db->get()->row();

            $owner['idowner'] = $result->idowner;
            $owner['username'] = $result->username;
            $owner['password'] = $result->password;
            
            $output['message'] = "Berhasil Menampilkan Profile!";
            $output['success'] = 1;
            $output['data'] = $owner;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getprofilebisnis_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('*');
            $this->db->from('tb_bisnis');
            $this->db->where('tb_bisnis.idbisnis',$idbisnis);
            $resultbisnis = $this->db->get()->row();

            $bisnis['idowner'] = $resultbisnis->idowner;
            $bisnis['idbisnis'] = $resultbisnis->idbisnis;
            $bisnis['emailbisnis'] = $resultbisnis->emailbisnis;
            $bisnis['namabisnis'] = $resultbisnis->namabisnis;
            $bisnis['notelponbisnis'] = $resultbisnis->notelponbisnis;
            $bisnis['idprovinsi'] = $resultbisnis->idprovinsi;
            $bisnis['idkabupaten'] = $resultbisnis->idkabupaten;
            $bisnis['idkecamatan'] = $resultbisnis->idkecamatan;
            $bisnis['logobisnis'] = base_url()."apici/assets/uploads/".$resultbisnis->logobisnis;
            
            $output['message'] = "Berhasil Menampilkan Profile!";
            $output['success'] = 1;
            $output['info'] = $bisnis;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editprofileowner_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("UPDATE tb_owner SET username = '$username', password = '$password' WHERE idowner = '$idowner'");
            
            $output['message'] = "Berhasil Edit Profile!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function editprofilbisnis_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        $idbisnis = $this->input->post('idbisnis');
        $namabisnis = $this->input->post('namabisnis');
        $notelponbisnis = $this->input->post('notelponbisnis');
        $idprovinsi = $this->input->post('idprovinsi');
        $idkabupaten = $this->input->post('idkabupaten');
        $idkecamatan = $this->input->post('idkecamatan');
        $image = $this->input->post('logobisnis');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $image = base64_decode($this->input->post("logobisnis"));
    
            $image_name = md5(uniqid(rand(), true));

            $filename = $image_name . '.' . 'png';
            //rename file name with random number
            $path = "./assets/uploads/".$filename;
            //image uploading folder path

            file_put_contents($path, $image);
            // image is bind and upload to respective folder

            $sql = $this->db->query("UPDATE tb_bisnis SET namabisnis = '$namabisnis', notelponbisnis = '$notelponbisnis', idprovinsi = '$idprovinsi', idkabupaten = '$idkabupaten', idkecamatan = '$idkecamatan', logobisnis = '$filename' WHERE idowner = '$idowner' AND idbisnis = '$idbisnis'");
            
            $output['message'] = "Berhasil Edit Profile!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function getprofileakun_post(){
        $this->load->library('form_validation');

        $idowner = $this->input->post('idowner');
        
        $this->form_validation->set_rules('idowner', 'idowner', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_owner.idowner, tb_owner.username, tb_bisnis.namabisnis, tb_bisnis.logobisnis');
            $this->db->from('tb_owner');
            $this->db->where('tb_owner.idowner', $idowner);
            $this->db->join('tb_bisnis', 'tb_owner.idowner = tb_bisnis.idowner');
            $result=$this->db->get()->row();

            $owner['idowner'] = $result->idowner;
            $owner['username'] = $result->username;
            $owner['namabisnis'] = $result->namabisnis;
            $owner['logobisnis'] = base_url()."apici/assets/uploads/".$result->logobisnis;
            
            $output['message'] = "Berhasil Menampilkan Profile!";
            $output['success'] = 1;
            $output['data'] = $owner;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
