<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
include "functionnew.php";

class Register extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function signupakun_post(){
        $this->load->library('form_validation');

        $namaowner = $this->input->post('namalengkap');
        $usernameowner = $this->input->post('username');
        $passwordowner = $this->input->post('password');
        $emailbisnis = $this->input->post('emailbisnis');
        $namabisnis = $this->input->post('namabisnis');
        $notelpbisnis = $this->input->post('notelponbisnis');
        $idprovinsibisnis = $this->input->post('idprovinsi');
        $idkabupatenbisnis = $this->input->post('idkabupaten');
        $idkecamatanbisnis = $this->input->post('idkecamatan');

        $this->form_validation->set_rules('namalengkap', 'namalengkap', 'trim|required');
        $this->form_validation->set_rules('username', 'username', 'trim|required');
        $this->form_validation->set_rules('password', 'password', 'trim|required');
        $this->form_validation->set_rules('emailbisnis', 'emailbisnis', 'trim|required');
        $this->form_validation->set_rules('namabisnis', 'namabisnis', 'trim|required');
        $this->form_validation->set_rules('notelponbisnis', 'notelponbisnis', 'trim|required');
        $this->form_validation->set_rules('idprovinsi', 'idprovinsi', 'trim|required');
        $this->form_validation->set_rules('idkabupaten', 'idkabupaten', 'trim|required');
        $this->form_validation->set_rules('idkecamatan', 'idkecamatan', 'trim|required');

         if ( $this->form_validation->run() != FALSE ) { 
            $createat = date('y-m-d H:i:s', strtotime('now'));
            $insertowner = $this->db->query("INSERT INTO tb_owner(namalengkap, username, password, created_at) VALUES('$namaowner','$usernameowner','$passwordowner', '$createat')");

            $lastidowner = $this->db->insert_id();

            $insertbisnis = $this->db->query("INSERT INTO tb_bisnis(idowner,emailbisnis,namabisnis,notelponbisnis,idprovinsi,idkabupaten,idkecamatan) VALUES('$lastidowner','$emailbisnis','$namabisnis','$notelpbisnis','$idprovinsibisnis','$idkabupatenbisnis','$idkecamatanbisnis') ");
            $idbisnis = $this->db->query("SELECT idbisnis FROM tb_bisnis WHERE idowner = '$lastidowner' ORDER BY idbisnis DESC LIMIT 1")->row();

            $listpayment = ["Dana", "Ovo", "LinkAja", "Gopay", "Shopeepay", "BCA", "BNI"];

            foreach($listpayment as $payment){
                $row = array(
                    "namatipepembayaran" => $payment,
                    "idbisnis" => $idbisnis->idbisnis,
                    "statusaktif" => '0',
                );
    
                $kategoriitem = $this->Model_master->insert_table('tb_tipepembayaran', $row);
            }

            $this->send_email($emailbisnis, $namaowner);
            $output['message'] = 'Sukses Mendaftar Akun';
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    
    }  

    public function cekemailbisnis_post(){
        $this->load->library('form_validation');

        $email = $this->input->post('email');

        $this->form_validation->set_rules('email', 'email', 'trim|required');

         if ( $this->form_validation->run() !== false ) { 
            
            $cek = $this->db->query("SELECT emailbisnis FROM tb_bisnis WHERE emailbisnis = '".$email."' ")->row_array();
            if ($cek) {
                $output['message'] = "Gagal, Akun email sudah di gunakan";
                $output['success'] = 0;
                $this->set_response($output);
            } else {
                $output['message'] = "Sukses";
                $output['success'] = 1;
                $this->set_response($output);
            }
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    
    }

    public function send_email($email, $nama){

      $subject  = 'Selamat Bergabung di TemanKasir';
      $message  = '<!DOCTYPE html>
      <html>
      <head>
      <meta charset="utf-8" />
      <title>TemanKasir Mailer System</title>
      <style type="text/css">
      hr.thin {
        height: 0.5px;
        border: 0;
        color: #333;
        background-color: #333;
      }
      </style>
      </head>
      <body>
      <Br>
      <div>

      </br>
      </br>
      </br>

      <p style="text-align:left;">
      Hai ' .$nama. '
      </p>
      </br>
      <p style="text-align:left;">
      Selamat Anda telah terdaftar di TemanKasir!
      </p>

      <p style="text-align:left;">
      Akun kamu sudah aktif! Kini kamu dapat menggunakan aplikasi TemanKasir. Terima kasih atas kepercayaan Anda telah memilih TemanKasir sebagai teman perjalanan bisnis Anda :)
      </p>

      <p style="text-align:left;">
      Salam Hormat
      </p>
      <p style="text-align:left;">
      TemanKasir Official <br>
      </p>
      </div>
      </body>
      </html>';
      smtp_mail($email, $subject, $message, '', '', 0, 0, false);

    }
}
