<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';

class Subscribe extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Model_master');
    }

    public function getpaymentsubs_post(){
        $this->load->library('form_validation');

        $idbisnis = $this->input->post('idbisnis');
        
        $this->form_validation->set_rules('idbisnis', 'idbisnis', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $sql = $this->db->query("SELECT * FROM tb_banklangganan")->result_array();
            $payArr = array();

            foreach($sql as $value){

                $pay['idbanklangganan'] = $value['idbanklangganan'];
                $pay['namabank'] = $value['namabank'];
                $pay['norekening'] = $value['norekening'];
                $pay['atasnama'] = $value['atasnama'];

                array_push($payArr, $pay);
            }
            
            $output['message'] = "Berhasil Menampilkan Bank!";
            $output['success'] = 1;
            $output['data'] = $payArr;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function gettipepaketlangganan_post(){
        $sql = $this->db->query("SELECT * FROM tb_tipepaketlangganan")->result_array();
        $payArr = array();

        foreach($sql as $value){

            $pay['idtipepaketlangganan'] = $value['idtipepaketlangganan'];
            $pay['namapaket'] = $value['namapaket'];
            $pay['durasilangganan'] = $value['durasilangganan'];
            $pay['hargalangganan'] = $value['hargalangganan'];

            array_push($payArr, $pay);
        }
        
        $output['message'] = "Berhasil Menampilkan Tipe Paket Langganan!";
        $output['success'] = 1;
        $output['data'] = $payArr;
        $this->set_response($output);
    }

    public function subscribe_post(){
        $this->load->library('form_validation');

        $data = array(
            "iduser" => $this->input->post('iduser'),
            "idtipepaket" => $this->input->post('idtipepaket'),
            "statuslangganan" => "0",
            "createdate" => date('Y-m-d H:i:s', strtotime('now')),
        );

        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');
        $this->form_validation->set_rules('idtipepaket', 'idtipepaket', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $datasubs = array(
                "iduser" => $this->input->post('iduser'),
                "idtipepaket" => $this->input->post('idtipepaket'),
                "statuslangganan" => "0",
                "createdate" => date('Y-m-d H:i:s', strtotime('now')),
            );

            $result = $this->Model_master->insert_table('tb_langganan', $datasubs);
            
            $output['message'] = "Berhasil mengajukan langganan!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function konfirmasibayar_post(){
        $this->load->library('form_validation');

        $str_result = '1234567890'; 
        $kodeacak = substr(str_shuffle($str_result), 0, 12);

        $data = array(
            "idlangganan" => $this->input->post('idlangganan'),
            "fotopembayaran" => $this->input->post('fotopembayaran'),
            "statuslangganan" => "1",
            "datestartsubs" => date('y-m-d H:i:s', strtotime('now')),
        );
        
        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('idlangganan', 'idlangganan', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $image = base64_decode($this->input->post("fotopembayaran"));
    
            $image_name = md5(uniqid(rand(), true));

            $filename = $image_name . '.' . 'png';
            //rename file name with random number
            $path = "./assets/uploads/".$filename;
            //image uploading folder path

            file_put_contents($path, $image);
            // image is bind and upload to respective folder

            $this->db->select('tb_langganan.*');
            $this->db->from('tb_langganan');
            $this->db->where('tb_langganan.idlangganan', $data['idlangganan']);
            $getpaket = $this->db->get()->row();

            $this->db->select('tb_tipepaketlangganan.*');
            $this->db->from('tb_tipepaketlangganan');
            $this->db->where('tb_tipepaketlangganan.idtipepaketlangganan', $getpaket->idtipepaket);
            $getdurasi = $this->db->get()->row();

            $durasilangganan = "";
            if($getdurasi->durasilangganan == "3 Bulan") {
                $durasilangganan = date('y-m-d H:i:s', strtotime('+3 months', strtotime('now')));
            } else if($getdurasi->durasilangganan == "6 Bulan") {
                $durasilangganan = date('y-m-d H:i:s', strtotime('+6 months', strtotime('now')));
            } else {
                $durasilangganan = date('y-m-d H:i:s', strtotime('+12 months', strtotime('now')));
            }
            
            $updatesubs = $this->db->query("UPDATE tb_langganan SET fotopembayaran = '$filename', statuslangganan ='$data[statuslangganan]', datestartsubs = '$data[datestartsubs]', dateendsubs = '$durasilangganan' WHERE idlangganan = $data[idlangganan]");
            
            $output['message'] = "Konfirmasi telah dilakukan, tunggu hingga admin memberikan konfirmasi!";
            $output['success'] = 1;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function gethistorilangganan_post(){
        $this->load->library('form_validation');

        $iduser = $this->input->post('iduser');
        
        $this->form_validation->set_rules('iduser', 'iduser', 'trim|required');

        if ( $this->form_validation->run() !== false ) { 

            $this->db->select('tb_langganan.*, tb_tipepaketlangganan.namapaket, tb_tipepaketlangganan.durasilangganan, tb_tipepaketlangganan.hargalangganan');
            $this->db->from('tb_langganan');
            $this->db->join('tb_tipepaketlangganan', 'tb_langganan.idtipepaket = tb_tipepaketlangganan.idtipepaketlangganan', 'left');
            $this->db->where('tb_langganan.iduser', $iduser);
            $gethistori = $this->db->get()->result_array();

            $arrhistori = array();

            foreach($gethistori as $value){

                $histori['idlangganan'] = $value['idlangganan'];
                $histori['namapaket'] = $value['namapaket'];
                $histori['durasilangganan'] = $value['durasilangganan'];
                $histori['hargalangganan'] = $value['hargalangganan'];
                if($value['statuslangganan'] == "1") {
                    $histori['status'] = "Berlangganan";
                } else {
                    $histori['status'] = "Masih berlaku habis";
                }

                $histori['datestartsubs'] = $value['datestartsubs'];
                $histori['dateendsubs'] = $value['dateendsubs'];

                array_push($arrhistori, $histori);
            }
            
            $output['message'] = "Berhasil Menampilkan Histori Langganan!";
            $output['success'] = 1;
            $output['data'] = $arrhistori;
            $this->set_response($output);
        }else{
            $this->set_response([
            'message' => validation_errors(),
            'success' => 0,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
